#include <amxmodx>
#include <amxmisc>

#define PLUGIN_NAME "Team Spr"
#define PLUGIN_VERSION "1.0.2"
#define PLUGIN_AUTHOR "tuty"

#define CT_SPRITE "sprites/ct_blue.spr"
#define T_SPRITE "sprites/t_red.spr"

new g_ct_blue_spr;
new g_t_red_spr;
new g_enabled_spr;
new g_sprtime;

public plugin_init()
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR);
	register_event("DeathMsg", "remove_spr", "b");
	register_event("ResetHUD", "reset_hud", "be");
	register_clcmd("say /spr", "CreateSprite");
	register_clcmd("say_team /spr", "CreateSprite");
	register_clcmd("say /sprtorles", "RemoveSprite");
	register_clcmd("say_team /sprtorles", "RemoveSprite");
	g_enabled_spr = register_cvar("teamspr_sprite_enabled", "1");
	g_sprtime = register_cvar("teamspr_sprite_time", "32767");
}
public plugin_precache()
{
	g_ct_blue_spr = precache_model(CT_SPRITE);
	g_t_red_spr = precache_model(T_SPRITE);
}
public CreateSprite(id)
{
	if(get_pcvar_num(g_enabled_spr) == 0 || !is_user_alive(id) || is_user_bot(id) || !is_user_connected(id) || is_user_hltv(id))
		return PLUGIN_HANDLED;
	
	message_begin(MSG_ALL, SVC_TEMPENTITY);
	write_byte(TE_PLAYERATTACHMENT);
	write_byte(id);
	write_coord(60);
	switch(get_user_team(id))
	{
		case 1:
		{
			write_short(g_t_red_spr);
		}
		case 2:
		{
			write_short(g_ct_blue_spr);
		}
	}
	write_short(get_pcvar_num(g_sprtime));
	message_end();
	
	client_print(id, print_chat, "[CsapatSpr] Sikeresen letrehozva a ^"Csapat Sprite Ikon^" a fejed folott!");
	client_cmd(id, "speak fvox/activated.wav");
	return PLUGIN_CONTINUE;
}
public RemoveSprite(id)
{
	if(get_pcvar_num(g_enabled_spr) == 0 || is_user_bot(id) || !is_user_connected(id))
		return PLUGIN_HANDLED;
		
	message_begin(MSG_ALL, SVC_TEMPENTITY);
	write_byte(TE_KILLPLAYERATTACHMENTS);
	write_byte(id);
	message_end();
	
	client_print(id, print_chat, "[CsapatSpr] Sikeresen torolve lett a fejed felol a ^"Csapat Sprite Ikon^"!");
	client_cmd(id, "speak fvox/deactivated.wav");
	return PLUGIN_CONTINUE;
}
public remove_spr()
{
	new deadid = read_data(2);
	
	message_begin(MSG_ALL, SVC_TEMPENTITY);
	write_byte(TE_KILLPLAYERATTACHMENTS);
	write_byte(deadid);
	message_end();

	return PLUGIN_CONTINUE;
}
public reset_hud()
{
	new id;
	for(id = 1; id <= get_maxplayers(); id++)
	{
		message_begin(MSG_ALL, SVC_TEMPENTITY);
		write_byte(TE_KILLPLAYERATTACHMENTS);
		write_byte(id);
		message_end();
	}
	return PLUGIN_CONTINUE;
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1033\\ f0\\ fs16 \n\\ par }
*/
